﻿<?LassoScript
	
	/*
			This page shows the details of a particular blog entry. It also
		shows all the comments posted for that entry and the form that is used
		to create a comment. If the current user is the blog's owner, then each
		comment has a link that can be used to delete the comment.
	*/
	
	if(action_param('detail')); // the detail action param must be provided here. 
								// the value is the id of the blog entry to show.
		local('detail' = action_param('detail'));
		// these params are present if a user is posting a new comment for this entry
		local('newComment'=action_param('newComment'),
				'newCommentAuthor'=action_param('commentAuthor'),
				'newCommentBody'=action_param('commentBody'));
		// this param is present if the blog owner is deleting one of the comments for this entry
		local('del' = action_param('del'));
		
		// search for the blog entry in question
		inline(-database='op_blog', -table='entries', -op='eq', 'id'=#detail, -search);
			if (found_count != 0); // if the blog entry is not found, then we will fall through to the calling page
									// resulting in the main blog author list being shown
				$handled = true;
				if (#newComment && #newCommentBody); // if a new comment is being posted...
					// add it to the comments table
					inline(-table='comments', 'id_entry'=#detail, 
							'author'=(#newCommentAuthor? #newCommentAuthor | 'anonymous'), 
							'body'=#newCommentBody,
							-add);
					/inline;
				/if;
				// search for the blog information. author name, title, id
				inline(-table='blogs', -op='eq', 'id'=field('id_blog'), -search,
						-returnField='author', -returnField='title', -returnField='id');
					// lookup and save these values for later
					local('blogAuthor'=field('author'), 'blogTitle'=field('title'), 
							'blogId'=field('id'));
					// if the current username is the blog author's name, then the user is the blog owner
					local('isOwner' = #blogAuthor == admin_currentusername);
					if (#isOwner && #del); // if this is the owner and they are deleting a comment...
						inline(-table='comments', -search, -op='eq', 'id'=#del, -returnField='id_entry');
							if (field('id_entry') == #detail);
								// delete it after confirming that the comment belongs to this blog
								inline(-delete, -keyField='id', -keyValue=#del);
								/inline;
							/if;
						/inline;
					/if;
				/inline;
				// display the data for this blog entry
				'<div class="group_list">\
					<div class="group">\
						<b class="rboth1 rrightclr"></b><b class="rboth2 rrightclr"></b><b class="rboth3 rrightclr"></b><b class="rboth4 rrightclr"></b>\
						<div class="group_title"><a href="'Application_appInfo->indexFile'">Blogs</a> &gt; \
							<a href="'Application_appInfo->indexFile'?list='#blogAuthor'">'#blogTitle'</a> &gt; '
							encode_html(field('title'))' by <i>'encode_html(#blogAuthor)'</i>\
							<div class="group_description">'encode_html(field('date'))'</div>\
						</div>\
						<div class="item">'
						encode_breaks(field('body'))
						'</div>\
					</div>\
					<div class="group">\
						<b class="rboth1 rrightclr"></b><b class="rboth2 rrightclr"></b><b class="rboth3 rrightclr"></b><b class="rboth4 rrightclr"></b>\
						<div class="group_title">\
							Comments
						</div>';
						// lookup and show all the comments for the blog entry
						inline(-table='comments', -op='eq', 'id_entry'=field('id'), -search,
								-returnField='id', -returnField='author', -returnField='date', -returnField='body',
								-sortField='date');
							if (found_count == 0);
							'<div class="item">\
								<div class="item_details">No comments have been posted for this blog entry.</div>\
							</div>';
							/if;
							records;
							'<div class="item">\
								<div class="item_title"><i>'encode_html(field('author'))'</i>';
								(#isOwner? ' - <a class="delete" href="'Application_appInfo->indexFile'?detail='#detail'&amp;del='field('id')'">(delete comment)</a>');
								'</div>\
								<div class="item_description">'encode_breaks(field('body'))'</div>\
								<div class="item_details">'encode_html(field('date'))'</div>\
							</div>';
							/records;
						/inline;
					'</div>'
					// show the New Comment form
					'<div class="group">\
						<b class="rboth1 rrightclr"></b><b class="rboth2 rrightclr"></b><b class="rboth3 rrightclr"></b><b class="rboth4 rrightclr"></b>\
						<div class="group_title">\
							Post A New Comment
						</div>\
						<div class="item">\
							<form method="POST" action="'Application_appInfo->indexFile'">\
								<input type="hidden" name="detail" value="'#detail'" />\
								Your Name<br />
								<input type="text" name="commentAuthor" size="50" value="'admin_currentusername'" /><br />
								Comment Text<br />
								<textarea name="commentBody" style="width: 80%; height: 100px"></textarea><br />
								<input type="submit" value="Submit Comment" name="newComment" />\
							</form>\
						</div>\
					</div>\
				</div>';		
			/if;
		/inline;	
	/if;
?>